unit Unit1;

//  6.   ,   
//      
//    (    
//  ).      
//     Image     .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Panel1: TPanel;
    Image1: TImage;
    Panel2: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    CbBoxFigure: TComboBox;
    StTxtBColor: TStaticText;
    StTxtPColor: TStaticText;
    CbBoxBStyle: TComboBox;
    CbBoxPicStyle: TComboBox;
    ColorDialog1: TColorDialog;
    BttClear: TButton;
    CbBoxNumP: TComboBox;
    Label6: TLabel;

    procedure StTxtBColorClick(Sender: TObject);
    procedure StTxtPColorClick(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure BttClearClick(Sender: TObject);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowFigure(XB, YB, XE, YE : Integer);
  end;

var
  Form1: TForm1;

var  ArrPnt     : array [0..3] of TPoint;

implementation

{$R *.dfm}

var
    bColor           : TColor;      //  
    pColor           : TColor;      //  
    SavePenMode      : TPenMode;    //   PenMode
    StartX, StartY   : Integer;     //   
    FiniteX, FiniteY : Integer;     //   
    Elastic          : Boolean;     //   
    ElasticShow      : Boolean;     //    

procedure TForm1.ShowFigure(XB, YB, XE, YE : Integer);
begin
  with Image1.Canvas do
  begin
    //     Color  Width
    Pen.Style   := psSolid;
    Pen.Color   := pColor;
    Pen.Width   := 1;
    //     Color  Style
    Brush.Color := bColor;
    case CbBoxBStyle.ItemIndex of
    0 : Brush.Style := bsClear;
    1 : Brush.Style := bsSolid;
    2 : Brush.Style := bsHorizontal;
    3 : Brush.Style := bsVertical;
    4 : Brush.Style := bsCross;
    5 : Brush.Style := bsBDiagonal;
    6 : Brush.Style := bsFDiagonal;
    7 : Brush.Style := bsDiagCross;
    end;
    //   Rectangle, RoundRect, Ellipse
    case CbBoxFigure.ItemIndex of
    0 : Rectangle(XB, YB, XE, YE);
    1 : RoundRect(XB, YB, XE, YE, Abs(XE - XB) div 3, Abs(YE - YB) div 3);
    2 : Ellipse(XB, YB, XE, YE);
    end;
  end; // of with Image1.Canvas
end;

//    Image
procedure ClearImage(RqImg : TImage);
begin
  with RqImg.Canvas do
  begin
     //     
     Brush.Color := RqImg.Parent.Brush.Color;
     Pen.Color   := RqImg.Parent.Brush.Color;
     Pen.Style   := psSolid;
     // 
     Brush.Style := bsSolid;
     Rectangle(0, 0, RqImg.Width, RqImg.Height);
  end; // of with RqImg.Canvas
end;

//   Image
procedure TForm1.BttClearClick(Sender: TObject);
begin
   ClearImage(Image1);
end;

//    
procedure TForm1.StTxtBColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    bColor := ColorDialog1.Color;   //  
    StTxtBColor.Color := bColor;
  end;
end;

//    
procedure TForm1.StTxtPColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    pColor := ColorDialog1.Color;   //  
    StTxtPColor.Color := pColor;
  end;
end;

//    
procedure SetPointData (Ind, X, Y : integer);
begin
   if (Ind >= Low(ArrPnt)) and (Ind <= High(ArrPnt))
   then begin
     ArrPnt[Ind].X := X;
     ArrPnt[Ind].Y := Y;
   end;
end;

// ,     
procedure TForm1.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   with Image1.Canvas do
   begin
     SavePenMode := Pen.Mode;       //   
     Pen.Mode    := pmNotXor;       //   NotXor
     Pen.Color   := pColor;
     Brush.Style := bsClear;        //   
   end;
   //   
   StartX  := X;
   StartY  := Y;
   FiniteX := X;
   FiniteY := Y;
   //        
   if CbBoxPicStyle.ItemIndex = 2
   then SetPointData(CbBoxNumP.ItemIndex, X, Y);
   Elastic := True;
   ElasticShow := False;
end;

// ,    
procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
   if Elastic = False then Exit;
   with Image1.Canvas do
   begin
     case CbBoxPicStyle.ItemIndex of
     0 : begin
           //   
           if ElasticShow
           then Rectangle(StartX, StartY, FiniteX, FiniteY);
           //   
           Rectangle(StartX, StartY, X, Y);
           ElasticShow := True;
         end;
     1 : begin
           //   
           if ElasticShow
           then begin
             MoveTo(StartX, StartY);
             LineTo(FiniteX, FiniteY);
           end;
           //   
           MoveTo(StartX, StartY);
           LineTo(X, Y);
           ElasticShow := True;
         end;
     2 : begin
           if ElasticShow
           then begin
             PolyLine (ArrPnt);
             PolyBezier(ArrPnt);
           end;
           SetPointData(CbBoxNumP.ItemIndex, X, Y);
           PolyLine (ArrPnt);
           PolyBezier(ArrPnt);
           ElasticShow := True;
         end;
     end; // of case
   end; // of with Image1.Canvas
   FiniteX := X;
   FiniteY := Y;
end;

// ,    
//     
procedure TForm1.Image1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   Elastic := False;
   with Image1.Canvas do
   begin
     case CbBoxPicStyle.ItemIndex of
     0 : begin
           //   
           if ElasticShow
           then begin
               Rectangle(StartX, StartY, FiniteX, FiniteY);
               ElasticShow := False;
           end;
           //   
           Pen.Mode := SavePenMode;
           //  
           ShowFigure(StartX, StartY, X, Y);
         end;
     1 : begin
           //   
           if ElasticShow
           then begin
              MoveTo(StartX, StartY);
              LineTo(FiniteX, FiniteY);
              ElasticShow := False;
           end;
           //   
           Pen.Mode := SavePenMode;
           //  
           MoveTo(StartX, StartY);
           LineTo(X, Y);
         end;
         2 : begin
               if ElasticShow
               then begin
                 PolyLine (ArrPnt);
                 PolyBezier(ArrPnt);
                 ElasticShow := False;
                end;
                //   
                Pen.Mode := SavePenMode;
                SetPointData(CbBoxNumP.ItemIndex, X, Y);
                PolyBezier(ArrPnt);
         end;
      end; // of case
   end;
end;

//   
procedure TForm1.FormCreate(Sender: TObject);
begin
  Elastic := false;
  bColor := clSkyBlue;    //  
  pColor := clNavy;       //  
  StTxtBColor.Color := bColor;
  StTxtPColor.Color := pColor;
  ClearImage(Image1);
  //
  ArrPnt[0].X := 100;
  ArrPnt[0].Y := 300;
  ArrPnt[1].X := 200;
  ArrPnt[1].Y := 50;
  ArrPnt[2].X := 300;
  ArrPnt[2].Y := 50;
  ArrPnt[3].X := 400;
  ArrPnt[3].Y := 300;
end;

end.
